#include "projet.h"

// BUFFER d'affichage
BITMAP *page;

// Regroupe les initialisations d'allegro, mode graphique, clavier, souris
void lancerToutAllegro(int largeur, int hauteur)
{
    allegro_init();
    install_keyboard();
    install_mouse();

    /// OUVERTURE MODE GRAPHIQUE (ouverture fentre allegro)
    set_color_depth(desktop_color_depth());
    if (set_gfx_mode(GFX_AUTODETECT_WINDOWED,largeur,hauteur,0,0)!=0)
    {
        allegro_message("probleme mode graphique : %s", allegro_error);
        allegro_exit();
        exit(EXIT_FAILURE);
    }

    show_mouse(screen); // Affiche pointeur de souris en mode allegro

    // CREATION DU BUFFER D'AFFICHAGE  la taille de l'cran
    page=create_bitmap(SCREEN_W,SCREEN_H);
    clear_bitmap(page);
}

// Fonctionne comme load_bitmap sauf qu'il ne prend pas NULL en 2me paramtre
// et qu'il termine le programme (avec message) en cas d'chec
//    Exemple de fonction wrapper (emballage d'une fct par une autre fct)
BITMAP *chargerImage(char *nomFichierImage)
{
    BITMAP *bmp;
    bmp=load_bitmap(nomFichierImage,NULL);
    if (bmp==NULL)
    {
        allegro_message("pas pu trouver/charger %s",nomFichierImage);
        allegro_exit();
        exit(EXIT_FAILURE);
    }
    printf("Image charg\202e : %s\n", nomFichierImage);
    return bmp;
}
